//___________________________________________________________________
//___________________________________________________________________
//  Copyright : 2021 BY HOLTEK SEMICONDUCTOR INC
//  File Name : ADC.c
// Description: 
//Targer Board: 
//   MCU      : BH67F2265
//   Author   : ming
//   Date     : 20210308
//   Version  : V00
//   History  :
//___________________________________________________________________
//___________________________________________________________________
#include "common.h"

u8	gu8v_battery_votage;

u8	gu8a_heart_wave_data;


u8	gu8a_heart_wave_data_uart;
u16	gu16v_pressure_uart;

u16	gu16v_scf_buff[8];
u16	gu16v_scf_buff_out[LU8C_scf_buff_out];
u16	gu16v_scf_output_xbuff[3];
u16	gu16v_scf_output_ybuff[3];

u16	gu16v_pressure_output_xbuff[2];
u16	gu16v_pressure_output_ybuff[2];

u16	gu16v_pressure_output;
u16	gu16v_pressure_output_old;
__16_type	gu16v_cal_300mmhg;
__16_type	gu16v_cal_0mmhg;
__16_type	gu16v_zero;
u16	gu8a_heart_wave_data_TEST;
u16	gu8a_PRESSURE_data_TEST;
__16_type	gu16v_old_pressure;
__16_type	gu16v_current_pressure;
/********************************************************************
Function: Get_ADC
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
u16 fun_Get_ADC(u8 lu8c_adc_channel)
{
	__16_type	lu8c_adc_rdata;
	_sadc0 = 0B00111111;
	_sadc1 = 0B11101011;
//	_adaccm = 1;
	switch(lu8c_adc_channel)
	{
		case 0:  _sadc0 &=0xf0;  _pas15 =1 ;_pas14 =1 ; break;	// pa6 an0
		case 1:  _sadc0 &=0xf1;  _pas17 =1 ;_pas16 =1 ; break;	// pa7 an1
		case 2:  _sadc0 &=0xf2;  _pcs01 =1 ;_pcs00 =1 ; break;	// pc0 an2
		case 3:  _sadc0 &=0xf3;  _pcs03 =1 ;_pcs02 =1 ; break;	// pc1 an3	
		case 4:  _sadc1 &=0x3f;  break;	// pgao2
		case 5:  _sadc1 &=0x5f;  break;	// vscf		
		case 6:  _sadc1 &=0x7f;  break;	// vscfr				
		case 7:  _sadc1 &=0x9f;  break;	// vbat		
	}
	
	GCC_DELAY(20);
	_start = 0;
	_start = 1;
	_start = 0;		
	while(_adbz != 0)
	{
	} 
	lu8c_adc_rdata.byte.byte0 = _sadol;
	lu8c_adc_rdata.byte.byte1 = _sadoh;
	_start = 0;
	_start = 0;	
	return lu8c_adc_rdata.u16;	
}

//
///********************************************************************
//Function: Get_ADC
//INPUT	:
//OUTPUT	:
//NOTE	:
//********************************************************************/
//u16 fun_Get_ADC_Key(u8 lu8c_adc_channel)
//{
//	__16_type	lu8c_adc_rdata;
//	_sadc0 = 0B00111111;
//	_sadc1 = 0B11101011;
//	_adaccm = 0;	
//	switch(lu8c_adc_channel)
//	{
//		case 0:  _sadc0 &=0xf0;  _pcs05 =1 ;_pcs04 =1 ; break;	// pc2 an0
//		case 1:  _sadc0 &=0xf1;  _pcs07 =1 ;_pcs06 =1 ; break;	// pc3 an1
//		case 2:  _sadc0 &=0xf2;  _pcs01 =1 ;_pcs00 =1 ; break;	// pc0 an2
//		case 3:  _sadc0 &=0xf3;  _pcs03 =1 ;_pcs02 =1 ; break;	// pc1 an3	
//		case 4:  _sadc1 &=0x3f;  break;	// pgao2
//		case 5:  _sadc1 &=0x5f;  break;	// vscf		
//		case 6:  _sadc1 &=0x7f;  break;	// vscfr				
//		case 7:  _sadc1 &=0x9f;  break;	// vbat		
//	}
//	_start = 0;
//	_start = 1;
//	_start = 0;	
//	GCC_NOP();	
//	while(_adbz != 0)
//	{
//	} 
//	lu8c_adc_rdata.byte.byte0 = _sadol;
//	lu8c_adc_rdata.byte.byte1 = _sadoh;
//	if(lu8c_adc_rdata.u16 == 0)
//	{
//		GCC_NOP();	
//	}
//	
//	return lu8c_adc_rdata.u16/16;	
//
//}





/********************************************************************
Function: Get_ADC
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void fun_Disable_ADC()
{
	_adcen = 0;

}

/********************************************************************
Function: Get_ADC
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void fun_Enable_ADC()
{
	_sadc0 = 0B00111111;
	_sadc1 = 0B11101011;	
	_adcen = 1;
}



/********************************************************************
Function: fun_iir_filter
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void fun_iir_filter(u16 lu16_current_adc_data)
{

	
	 s32	lu32v_filter_buff;
	 
	 
	 //gu8a_heart_wave_data_TEST = lu16_current_adc_data;
	 //
	 gu16v_scf_output_xbuff[2] = gu16v_scf_output_xbuff[1];			
	 gu16v_scf_output_xbuff[1] = gu16v_scf_output_xbuff[0];		
	 gu16v_scf_output_xbuff[0] = lu16_current_adc_data;
	 gu16v_scf_output_ybuff[2] = gu16v_scf_output_ybuff[1];			
	 gu16v_scf_output_ybuff[1] = gu16v_scf_output_ybuff[0];			
	 //
	 lu32v_filter_buff = 0;
	 lu32v_filter_buff = 	246*(s32)(gu16v_scf_output_xbuff[0]+gu16v_scf_output_xbuff[2])+492*(s32)gu16v_scf_output_xbuff[1]
	 						+15093*(s32)gu16v_scf_output_ybuff[1]-6079*(s32)gu16v_scf_output_ybuff[2];						
	 lu32v_filter_buff /=10000;
	 if(lu32v_filter_buff>4095)
	 {
	 	lu32v_filter_buff = 4095;
	 }
	 if(lu32v_filter_buff<0)
	 {
	 	lu32v_filter_buff = 0;
	 }	 
	 gu16v_scf_output_ybuff[0] = lu32v_filter_buff;	
	gu8a_heart_wave_data = lu32v_filter_buff/16;
	gu8a_heart_wave_data_TEST	=lu32v_filter_buff;		
	gu8v_wave_uart_buff = gu8a_heart_wave_data;
//	u8	i;
//	u16	lu16v_sum;
//	lu16v_sum = 0;
//	for(i=0;i<LU8C_scf_buff_out-1;i++)
//	{
//		gu16v_scf_buff_out[i] = gu16v_scf_buff_out[i+1];	
//		lu16v_sum += gu16v_scf_buff_out[i];
//	}
//	gu16v_scf_buff_out[LU8C_scf_buff_out-1] = lu16_current_adc_data;
//	lu16v_sum += gu16v_scf_buff_out[LU8C_scf_buff_out-1];
//	lu16_current_adc_data = lu16v_sum/LU8C_scf_buff_out;
//	gu8a_heart_wave_data = lu16_current_adc_data/16;
//	gu8a_heart_wave_data_TEST	=lu16_current_adc_data;	
//	gu8v_wave_uart_buff = gu8a_heart_wave_data;

}


/********************************************************************
Function: fun_iir_filter1
INPUT	:
OUTPUT	:
NOTE	:gu32v_pressure_output_ybuff
********************************************************************/
void fun_iir_filter1(u16 lu16_current_adc_data)
{
//	 u32	lu32v_filter_buff;
//	 gu8a_PRESSURE_data_TEST = lu16_current_adc_data;
//	gu16v_pressure_output_xbuff[1] = gu16v_pressure_output_xbuff[0];		
//	gu16v_pressure_output_xbuff[0] = lu16_current_adc_data;			
//	gu16v_pressure_output_ybuff[1] = gu16v_pressure_output_ybuff[0];			
//	lu32v_filter_buff = 0;
//	lu32v_filter_buff= 	50*(u32)(gu16v_pressure_output_xbuff[0]+gu16v_pressure_output_xbuff[1])+900*(u32)gu16v_pressure_output_ybuff[1];						
//	lu32v_filter_buff /=1000;
//	gu16v_pressure_output_ybuff[0] = lu32v_filter_buff;	
//	gu16v_pressure_output = lu32v_filter_buff;	
//	
	gu8a_PRESSURE_data_TEST = lu16_current_adc_data;
	gu16v_pressure_output = lu16_current_adc_data;	
	

	
	
	
		
	
}




/********************************************************************
Function: Get_ADC
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void TEST_ADC()
{
	__16_type	lu8c_adc_rdata_buff;
	while(1)
	{
		GCC_CLRWDT();
		lu8c_adc_rdata_buff.u16 = fun_Get_ADC(AN6);

		lu8c_adc_rdata_buff.u16++;
//		Uart_putchar(47);			
//		Uart_putchar(0);				
//		Uart_putchar(lu8c_adc_rdata_buff.byte.byte1);				
//		Uart_putchar(lu8c_adc_rdata_buff.byte.byte0);	
//		Uart_putchar(0);				
//		Uart_putchar(57+lu8c_adc_rdata_buff.byte.byte1+lu8c_adc_rdata_buff.byte.byte0);							
//		Uart_putchar(10);
//		GCC_DELAY(60000);		
//		GCC_DELAY(60000);
//		GCC_DELAY(60000);			
	}
}
